unit CoreClassesUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  PESSOA = class;
  CLIENTE = class;
  FUNCIONARIO = class;
  [UmlElement('Package')]
  [EcoCodeGenVersion('1.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(PESSOA))]
  [UmlMetaAttribute('ownedElement', TypeOf(FUNCIONARIO))]
  [UmlMetaAttribute('ownedElement', TypeOf(CLIENTE))]
  CoreClasses = class
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]
  [UmlCollection(TypeOf(PESSOA))]
  [EcoAutoGenerated]
  IPESSOAList = interface
    function get_Count: Integer;
    function get_Item(index: Integer): PESSOA;
    procedure set_Item(index: Integer; Value: PESSOA);
    property Count: Integer read get_Count;
    property Item[index: Integer]: PESSOA read get_Item write set_Item; default;
    procedure Clear;
    procedure RemoveAt(index: Integer);
    function Add(value: PESSOA): Integer;
    function Contains(value: PESSOA): Boolean;
    function IndexOf(value: PESSOA): Integer;
    procedure Insert(index: Integer; value: PESSOA);
    procedure Remove(value: PESSOA);
  end;
  [UmlElement]
  PESSOA = class(System.Object, ILoopBack)
  strict protected
    [EcoAutoGenerated]
    _content: IContent;
    function get__NOME: string;
    procedure set__NOME(Value: string);
    [EcoAutoGenerated]
    property _NOME: string read get__NOME write set__NOME;
    function get__ENDERECO: string;
    procedure set__ENDERECO(Value: string);
    [EcoAutoGenerated]
    property _ENDERECO: string read get__ENDERECO write set__ENDERECO;
    function get__BAIRRO: string;
    procedure set__BAIRRO(Value: string);
    [EcoAutoGenerated]
    property _BAIRRO: string read get__BAIRRO write set__BAIRRO;
    function get__CIDADE: string;
    procedure set__CIDADE(Value: string);
    [EcoAutoGenerated]
    property _CIDADE: string read get__CIDADE write set__CIDADE;
    function get__ESTADO: string;
    procedure set__ESTADO(Value: string);
    [EcoAutoGenerated]
    property _ESTADO: string read get__ESTADO write set__ESTADO;
    function get__CEP: string;
    procedure set__CEP(Value: string);
    [EcoAutoGenerated]
    property _CEP: string read get__CEP write set__CEP;
    function get__TELEFONE: string;
    procedure set__TELEFONE(Value: string);
    [EcoAutoGenerated]
    property _TELEFONE: string read get__TELEFONE write set__TELEFONE;
  protected
  const
    PESSOAFirstMember = 0;
  const
    PESSOAMemberCount = (PESSOA.PESSOAFirstMember + 7);
  strict private
    {$REGION 'Autogenerated ECO code'}
  public
    [EcoAutoGenerated]
    function AsIObject: IObject;
    [EcoAutoGenerated]
    constructor Create(content: IContent); overload;
    [EcoAutoGenerated]
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    [EcoAutoGenerated]
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
  type
    [EcoAutoGenerated]
    PESSOAListAdapter = class(ObjectListAdapter, IPESSOAList)
    public
      constructor Create(source: IList);
      function Add(value: PESSOA): Integer;
      function Contains(value: PESSOA): Boolean;
      function IndexOf(value: PESSOA): Integer;
      procedure Insert(index: Integer; value: PESSOA);
      procedure Remove(value: PESSOA);
      function get_Item(index: Integer): PESSOA;
      procedure set_Item(index: Integer; value: PESSOA);
    end;
    function get_NOME: string;
    procedure set_NOME(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 0))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property NOME: string read get_NOME write set_NOME;
    function get_ENDERECO: string;
    procedure set_ENDERECO(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 1))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property ENDERECO: string read get_ENDERECO write set_ENDERECO;
    function get_BAIRRO: string;
    procedure set_BAIRRO(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 2))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property BAIRRO: string read get_BAIRRO write set_BAIRRO;
    function get_CIDADE: string;
    procedure set_CIDADE(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 3))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property CIDADE: string read get_CIDADE write set_CIDADE;
    function get_ESTADO: string;
    procedure set_ESTADO(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 4))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property ESTADO: string read get_ESTADO write set_ESTADO;
    function get_CEP: string;
    procedure set_CEP(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 5))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property CEP: string read get_CEP write set_CEP;
    function get_TELEFONE: string;
    procedure set_TELEFONE(Value: string);
    [UmlElement(Index=(PESSOA.PESSOAFirstMember + 6))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property TELEFONE: string read get_TELEFONE write set_TELEFONE;
  strict protected
    [EcoAutoGenerated]
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    [EcoAutoGenerated]
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    [EcoAutoMaintained]
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  [UmlCollection(TypeOf(CLIENTE))]
  [EcoAutoGenerated]
  ICLIENTEList = interface
    function get_Count: Integer;
    function get_Item(index: Integer): CLIENTE;
    procedure set_Item(index: Integer; Value: CLIENTE);
    property Count: Integer read get_Count;
    property Item[index: Integer]: CLIENTE read get_Item write set_Item; default;
    procedure Clear;
    procedure RemoveAt(index: Integer);
    function Add(value: CLIENTE): Integer;
    function Contains(value: CLIENTE): Boolean;
    function IndexOf(value: CLIENTE): Integer;
    procedure Insert(index: Integer; value: CLIENTE);
    procedure Remove(value: CLIENTE);
  end;
  [UmlElement]
  CLIENTE = class(PESSOA)
  strict protected
    function get__SEXO: string;
    procedure set__SEXO(Value: string);
    [EcoAutoGenerated]
    property _SEXO: string read get__SEXO write set__SEXO;
    function get__ESTADO_CIVIL: string;
    procedure set__ESTADO_CIVIL(Value: string);
    [EcoAutoGenerated]
    property _ESTADO_CIVIL: string read get__ESTADO_CIVIL write set__ESTADO_CIVIL;
    function get__CPF: string;
    procedure set__CPF(Value: string);
    [EcoAutoGenerated]
    property _CPF: string read get__CPF write set__CPF;
    function get__CGC: string;
    procedure set__CGC(Value: string);
    [EcoAutoGenerated]
    property _CGC: string read get__CGC write set__CGC;
    function get__LIMITE: string;
    procedure set__LIMITE(Value: string);
    [EcoAutoGenerated]
    property _LIMITE: string read get__LIMITE write set__LIMITE;
    function get__INSCRICAO_ESTADUAL: string;
    procedure set__INSCRICAO_ESTADUAL(Value: string);
    [EcoAutoGenerated]
    property _INSCRICAO_ESTADUAL: string read get__INSCRICAO_ESTADUAL 
      write set__INSCRICAO_ESTADUAL;
    function get__INSCRICAO_MUNICIPAL: string;
    procedure set__INSCRICAO_MUNICIPAL(Value: string);
    [EcoAutoGenerated]
    property _INSCRICAO_MUNICIPAL: string read get__INSCRICAO_MUNICIPAL 
      write set__INSCRICAO_MUNICIPAL;
  protected
  const
    CLIENTEFirstMember = CLIENTE.PESSOAMemberCount;
  const
    CLIENTEMemberCount = (CLIENTE.CLIENTEFirstMember + 7);
  strict private
    {$REGION 'Autogenerated ECO code'}
  public
    [EcoAutoGenerated]
    constructor Create(content: IContent); overload;
    [EcoAutoGenerated]
    function get_MemberByIndex(index: Integer): System.Object; override;
    [EcoAutoGenerated]
    procedure set_MemberByIndex(index: Integer; value: System.Object); override;
    function get_SEXO: string;
    procedure set_SEXO(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 0))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property SEXO: string read get_SEXO write set_SEXO;
    function get_ESTADO_CIVIL: string;
    procedure set_ESTADO_CIVIL(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 1))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property ESTADO_CIVIL: string read get_ESTADO_CIVIL write set_ESTADO_CIVIL;
    function get_CPF: string;
    procedure set_CPF(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 2))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property CPF: string read get_CPF write set_CPF;
    function get_CGC: string;
    procedure set_CGC(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 3))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property CGC: string read get_CGC write set_CGC;
    function get_LIMITE: string;
    procedure set_LIMITE(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 4))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property LIMITE: string read get_LIMITE write set_LIMITE;
    function get_INSCRICAO_ESTADUAL: string;
    procedure set_INSCRICAO_ESTADUAL(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 5))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property INSCRICAO_ESTADUAL: string read get_INSCRICAO_ESTADUAL 
      write set_INSCRICAO_ESTADUAL;
    function get_INSCRICAO_MUNICIPAL: string;
    procedure set_INSCRICAO_MUNICIPAL(Value: string);
    [UmlElement(Index=(CLIENTE.CLIENTEFirstMember + 6))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property INSCRICAO_MUNICIPAL: string read get_INSCRICAO_MUNICIPAL 
      write set_INSCRICAO_MUNICIPAL;
  type
    [EcoAutoGenerated]
    CLIENTEListAdapter = class(CoreClassesUnit.PESSOA.PESSOAListAdapter, ICLIENTEList)
    public
      constructor Create(source: IList);
      function Add(value: CLIENTE): Integer;
      function Contains(value: CLIENTE): Boolean;
      function IndexOf(value: CLIENTE): Integer;
      procedure Insert(index: Integer; value: CLIENTE);
      procedure Remove(value: CLIENTE);
      function get_Item(index: Integer): CLIENTE;
      procedure set_Item(index: Integer; value: CLIENTE);
    end;
  strict private
    {$ENDREGION}
  public
    [EcoAutoMaintained]
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  [UmlCollection(TypeOf(FUNCIONARIO))]
  [EcoAutoGenerated]
  IFUNCIONARIOList = interface
    function get_Count: Integer;
    function get_Item(index: Integer): FUNCIONARIO;
    procedure set_Item(index: Integer; Value: FUNCIONARIO);
    property Count: Integer read get_Count;
    property Item[index: Integer]: FUNCIONARIO read get_Item write set_Item; default;
    procedure Clear;
    procedure RemoveAt(index: Integer);
    function Add(value: FUNCIONARIO): Integer;
    function Contains(value: FUNCIONARIO): Boolean;
    function IndexOf(value: FUNCIONARIO): Integer;
    procedure Insert(index: Integer; value: FUNCIONARIO);
    procedure Remove(value: FUNCIONARIO);
  end;
  [UmlElement]
  FUNCIONARIO = class(PESSOA)
  strict protected
    function get__MAE: string;
    procedure set__MAE(Value: string);
    [EcoAutoGenerated]
    property _MAE: string read get__MAE write set__MAE;
    function get__PAI: string;
    procedure set__PAI(Value: string);
    [EcoAutoGenerated]
    property _PAI: string read get__PAI write set__PAI;
    function get__RG: string;
    procedure set__RG(Value: string);
    [EcoAutoGenerated]
    property _RG: string read get__RG write set__RG;
    function get__PIS: string;
    procedure set__PIS(Value: string);
    [EcoAutoGenerated]
    property _PIS: string read get__PIS write set__PIS;
    function get__CTPS: string;
    procedure set__CTPS(Value: string);
    [EcoAutoGenerated]
    property _CTPS: string read get__CTPS write set__CTPS;
    function get__SALARIO: System.Double;
    procedure set__SALARIO(Value: System.Double);
    [EcoAutoGenerated]
    property _SALARIO: System.Double read get__SALARIO write set__SALARIO;
    function get__CARGO: string;
    procedure set__CARGO(Value: string);
    [EcoAutoGenerated]
    property _CARGO: string read get__CARGO write set__CARGO;
  protected
  const
    FUNCIONARIOFirstMember = FUNCIONARIO.PESSOAMemberCount;
  const
    FUNCIONARIOMemberCount = (FUNCIONARIO.FUNCIONARIOFirstMember + 7);
  strict private
    {$REGION 'Autogenerated ECO code'}
  public
    [EcoAutoGenerated]
    constructor Create(content: IContent); overload;
    [EcoAutoGenerated]
    function get_MemberByIndex(index: Integer): System.Object; override;
    [EcoAutoGenerated]
    procedure set_MemberByIndex(index: Integer; value: System.Object); override;
  type
    [EcoAutoGenerated]
    FUNCIONARIOListAdapter = class(ObjectListAdapter, IFUNCIONARIOList)
    public
      constructor Create(source: IList);
      function Add(value: FUNCIONARIO): Integer;
      function Contains(value: FUNCIONARIO): Boolean;
      function IndexOf(value: FUNCIONARIO): Integer;
      procedure Insert(index: Integer; value: FUNCIONARIO);
      procedure Remove(value: FUNCIONARIO);
      function get_Item(index: Integer): FUNCIONARIO;
      procedure set_Item(index: Integer; value: FUNCIONARIO);
    end;
    function get_MAE: string;
    procedure set_MAE(Value: string);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 0))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property MAE: string read get_MAE write set_MAE;
    function get_PAI: string;
    procedure set_PAI(Value: string);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 1))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property PAI: string read get_PAI write set_PAI;
    function get_RG: string;
    procedure set_RG(Value: string);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 2))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property RG: string read get_RG write set_RG;
    function get_PIS: string;
    procedure set_PIS(Value: string);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 3))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property PIS: string read get_PIS write set_PIS;
    function get_CTPS: STRING;
    procedure set_CTPS(Value: STRING);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 4))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property CTPS: STRING read get_CTPS write set_CTPS;
    function get_SALARIO: System.Double;
    procedure set_SALARIO(Value: System.Double);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 5))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property SALARIO: System.Double read get_SALARIO write set_SALARIO;
    function get_CARGO: string;
    procedure set_CARGO(Value: string);
    [UmlElement(Index=(FUNCIONARIO.FUNCIONARIOFirstMember + 6))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property CARGO: string read get_CARGO write set_CARGO;
  strict private
    {$ENDREGION}
  public
    [EcoAutoMaintained]
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation



function PESSOA.AsIObject: IObject;
begin
  Result := Self._content.AsIObject;
end;

constructor PESSOA.Create(content: IContent);
begin
  inherited Create;
  Self._content := content;
end;

function PESSOA.get_MemberByIndex(index: Integer): System.Object;
begin
  case index of
    PESSOAFirstMember + 0:
        result := System.Object(self.NOME);
    PESSOAFirstMember + 1:
        result := System.Object(self.ENDERECO);
    PESSOAFirstMember + 2:
        result := System.Object(self.BAIRRO);
    PESSOAFirstMember + 3:
        result := System.Object(self.CIDADE);
    PESSOAFirstMember + 4:
        result := System.Object(self.ESTADO);
    PESSOAFirstMember + 5:
        result := System.Object(self.CEP);
    PESSOAFirstMember + 6:
        result := System.Object(self.TELEFONE);
    else
      raise System.IndexOutOfRangeException.Create();
  end;
end;

procedure PESSOA.set_MemberByIndex(index: Integer; value: System.Object);
begin
  case index of
    PESSOAFirstMember + 0:
      self.NOME := string(value);
    PESSOAFirstMember + 1:
      self.ENDERECO := string(value);
    PESSOAFirstMember + 2:
      self.BAIRRO := string(value);
    PESSOAFirstMember + 3:
      self.CIDADE := string(value);
    PESSOAFirstMember + 4:
      self.ESTADO := string(value);
    PESSOAFirstMember + 5:
      self.CEP := string(value);
    PESSOAFirstMember + 6:
      self.TELEFONE := string(value);
    else
      raise System.IndexOutOfRangeException.Create();
  end;
end;

procedure PESSOA.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self._content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self._content := factory.CreateContent(Self);
  end;
end;

procedure PESSOA.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self._content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self._content, Self);
    Self._content := nil;
  end;
end;
{$ENDREGION}

constructor PESSOA.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function PESSOA.get__TELEFONE: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 6))));
end;

procedure PESSOA.set__TELEFONE(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 6), (System.Object(Value)));
end;

function PESSOA.get_TELEFONE: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._TELEFONE;
end;

procedure PESSOA.set_TELEFONE(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._TELEFONE := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function PESSOA.get__CEP: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 5))));
end;

procedure PESSOA.set__CEP(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 5), (System.Object(Value)));
end;

function PESSOA.get_CEP: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._CEP;
end;

procedure PESSOA.set_CEP(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._CEP := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function PESSOA.get__ESTADO: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 4))));
end;

procedure PESSOA.set__ESTADO(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 4), (System.Object(Value)));
end;

function PESSOA.get_ESTADO: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._ESTADO;
end;

procedure PESSOA.set_ESTADO(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._ESTADO := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function PESSOA.get__CIDADE: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 3))));
end;

procedure PESSOA.set__CIDADE(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 3), (System.Object(Value)));
end;

function PESSOA.get_CIDADE: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._CIDADE;
end;

procedure PESSOA.set_CIDADE(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._CIDADE := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function PESSOA.get__BAIRRO: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 2))));
end;

procedure PESSOA.set__BAIRRO(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 2), (System.Object(Value)));
end;

function PESSOA.get_BAIRRO: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._BAIRRO;
end;

procedure PESSOA.set_BAIRRO(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._BAIRRO := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function PESSOA.get__ENDERECO: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 1))));
end;

procedure PESSOA.set__ENDERECO(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 1), (System.Object(Value)));
end;

function PESSOA.get_ENDERECO: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._ENDERECO;
end;

procedure PESSOA.set_ENDERECO(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._ENDERECO := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function PESSOA.get__NOME: string;
begin
  Result := (string(Self._content.get_MemberByIndex((PESSOAFirstMember + 0))));
end;

procedure PESSOA.set__NOME(Value: string);
begin
  Self._content.set_MemberByIndex((PESSOAFirstMember + 0), (System.Object(Value)));
end;

function PESSOA.get_NOME: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._NOME;
end;

procedure PESSOA.set_NOME(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._NOME := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;



constructor PESSOA.PESSOAListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function PESSOA.PESSOAListAdapter.Add(value: PESSOA): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function PESSOA.PESSOAListAdapter.Contains(value: PESSOA): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function PESSOA.PESSOAListAdapter.IndexOf(value: PESSOA): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure PESSOA.PESSOAListAdapter.Insert(index: Integer; value: PESSOA);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure PESSOA.PESSOAListAdapter.Remove(value: PESSOA);
begin
  Self.Adaptee.Remove(value);
end;

function PESSOA.PESSOAListAdapter.get_Item(index: Integer): PESSOA;
begin
  Result := PESSOA(Adaptee[index]);
end;

procedure PESSOA.PESSOAListAdapter.set_Item(index: Integer; value: PESSOA);
begin
  Adaptee[index] := value;
end;

constructor CLIENTE.Create(content: IContent);
begin
  inherited Create(content);
end;

function CLIENTE.get_MemberByIndex(index: Integer): System.Object;
begin
  case index of
    CLIENTEFirstMember + 0:
        result := System.Object(self.SEXO);
    CLIENTEFirstMember + 1:
        result := System.Object(self.ESTADO_CIVIL);
    CLIENTEFirstMember + 2:
        result := System.Object(self.CPF);
    CLIENTEFirstMember + 3:
        result := System.Object(self.CGC);
    CLIENTEFirstMember + 4:
        result := System.Object(self.LIMITE);
    CLIENTEFirstMember + 5:
        result := System.Object(self.INSCRICAO_ESTADUAL);
    CLIENTEFirstMember + 6:
        result := System.Object(self.INSCRICAO_MUNICIPAL);
    else
      result := inherited get_MemberByIndex(index);
  end;
end;

procedure CLIENTE.set_MemberByIndex(index: Integer; value: System.Object);
begin
  case index of
    CLIENTEFirstMember + 0:
      self.SEXO := string(value);
    CLIENTEFirstMember + 1:
      self.ESTADO_CIVIL := string(value);
    CLIENTEFirstMember + 2:
      self.CPF := string(value);
    CLIENTEFirstMember + 3:
      self.CGC := string(value);
    CLIENTEFirstMember + 4:
      self.LIMITE := string(value);
    CLIENTEFirstMember + 5:
      self.INSCRICAO_ESTADUAL := string(value);
    CLIENTEFirstMember + 6:
      self.INSCRICAO_MUNICIPAL := string(value);
    else
      inherited set_MemberByIndex(index, value);
  end;
end;
{$ENDREGION}

constructor CLIENTE.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

constructor CLIENTE.CLIENTEListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function CLIENTE.CLIENTEListAdapter.Add(value: CLIENTE): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function CLIENTE.CLIENTEListAdapter.Contains(value: CLIENTE): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function CLIENTE.CLIENTEListAdapter.IndexOf(value: CLIENTE): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure CLIENTE.CLIENTEListAdapter.Insert(index: Integer; value: CLIENTE);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure CLIENTE.CLIENTEListAdapter.Remove(value: CLIENTE);
begin
  Self.Adaptee.Remove(value);
end;

function CLIENTE.CLIENTEListAdapter.get_Item(index: Integer): CLIENTE;
begin
  Result := CLIENTE(Adaptee[index]);
end;

procedure CLIENTE.CLIENTEListAdapter.set_Item(index: Integer; value: CLIENTE);
begin
  Adaptee[index] := value;
end;



function CLIENTE.get__INSCRICAO_MUNICIPAL: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 6))));
end;

procedure CLIENTE.set__INSCRICAO_MUNICIPAL(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 6), (System.Object(Value)));
end;

function CLIENTE.get_INSCRICAO_MUNICIPAL: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._INSCRICAO_MUNICIPAL;
end;

procedure CLIENTE.set_INSCRICAO_MUNICIPAL(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._INSCRICAO_MUNICIPAL := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function CLIENTE.get__INSCRICAO_ESTADUAL: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 5))));
end;

procedure CLIENTE.set__INSCRICAO_ESTADUAL(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 5), (System.Object(Value)));
end;

function CLIENTE.get_INSCRICAO_ESTADUAL: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._INSCRICAO_ESTADUAL;
end;

procedure CLIENTE.set_INSCRICAO_ESTADUAL(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._INSCRICAO_ESTADUAL := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function CLIENTE.get__LIMITE: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 4))));
end;

procedure CLIENTE.set__LIMITE(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 4), (System.Object(Value)));
end;

function CLIENTE.get_LIMITE: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._LIMITE;
end;

procedure CLIENTE.set_LIMITE(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._LIMITE := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function CLIENTE.get__CGC: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 3))));
end;

procedure CLIENTE.set__CGC(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 3), (System.Object(Value)));
end;

function CLIENTE.get_CGC: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._CGC;
end;

procedure CLIENTE.set_CGC(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._CGC := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function CLIENTE.get__CPF: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 2))));
end;

procedure CLIENTE.set__CPF(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 2), (System.Object(Value)));
end;

function CLIENTE.get_CPF: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._CPF;
end;

procedure CLIENTE.set_CPF(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._CPF := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function CLIENTE.get__ESTADO_CIVIL: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 1))));
end;

procedure CLIENTE.set__ESTADO_CIVIL(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 1), (System.Object(Value)));
end;

function CLIENTE.get_ESTADO_CIVIL: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._ESTADO_CIVIL;
end;

procedure CLIENTE.set_ESTADO_CIVIL(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._ESTADO_CIVIL := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function CLIENTE.get__SEXO: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CLIENTEFirstMember + 0))));
end;

procedure CLIENTE.set__SEXO(Value: string);
begin
  Self._content.set_MemberByIndex((CLIENTEFirstMember + 0), (System.Object(Value)));
end;

function CLIENTE.get_SEXO: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._SEXO;
end;

procedure CLIENTE.set_SEXO(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._SEXO := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

constructor FUNCIONARIO.Create(content: IContent);
begin
  inherited Create(content);
end;

function FUNCIONARIO.get_MemberByIndex(index: Integer): System.Object;
begin
  case index of
    FUNCIONARIOFirstMember + 0:
        result := System.Object(self.MAE);
    FUNCIONARIOFirstMember + 1:
        result := System.Object(self.PAI);
    FUNCIONARIOFirstMember + 2:
        result := System.Object(self.RG);
    FUNCIONARIOFirstMember + 3:
        result := System.Object(self.PIS);
    FUNCIONARIOFirstMember + 4:
        result := System.Object(self.CTPS);
    FUNCIONARIOFirstMember + 5:
        result := System.Object(self.SALARIO);
    FUNCIONARIOFirstMember + 6:
        result := System.Object(self.CARGO);
    else
      result := inherited get_MemberByIndex(index);
  end;
end;

procedure FUNCIONARIO.set_MemberByIndex(index: Integer; value: System.Object);
begin
  case index of
    FUNCIONARIOFirstMember + 0:
      self.MAE := string(value);
    FUNCIONARIOFirstMember + 1:
      self.PAI := string(value);
    FUNCIONARIOFirstMember + 2:
      self.RG := string(value);
    FUNCIONARIOFirstMember + 3:
      self.PIS := string(value);
    FUNCIONARIOFirstMember + 4:
      self.CTPS := STRING(value);
    FUNCIONARIOFirstMember + 5:
      self.SALARIO := Double(value);
    FUNCIONARIOFirstMember + 6:
      self.CARGO := string(value);
    else
      inherited set_MemberByIndex(index, value);
  end;
end;
{$ENDREGION}

constructor FUNCIONARIO.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function FUNCIONARIO.get__CARGO: string;
begin
  Result := (string(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember + 
      6))));
end;

procedure FUNCIONARIO.set__CARGO(Value: string);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 6), (System.Object(Value)));
end;

function FUNCIONARIO.get_CARGO: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._CARGO;
end;

procedure FUNCIONARIO.set_CARGO(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._CARGO := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function FUNCIONARIO.get__SALARIO: System.Double;
begin
  Result := (System.Double(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember 
      + 5))));
end;

procedure FUNCIONARIO.set__SALARIO(Value: System.Double);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 5), (System.Object(Value)));
end;

function FUNCIONARIO.get_SALARIO: System.Double;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._SALARIO;
end;

procedure FUNCIONARIO.set_SALARIO(Value: System.Double);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._SALARIO := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function FUNCIONARIO.get__CTPS: string;
begin
  Result := (string(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember + 
      4))));
end;

procedure FUNCIONARIO.set__CTPS(Value: string);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 4), (System.Object(Value)));
end;

function FUNCIONARIO.get_CTPS: STRING;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._CTPS;
end;

procedure FUNCIONARIO.set_CTPS(Value: STRING);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._CTPS := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function FUNCIONARIO.get__PIS: string;
begin
  Result := (string(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember + 
      3))));
end;

procedure FUNCIONARIO.set__PIS(Value: string);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 3), (System.Object(Value)));
end;

function FUNCIONARIO.get_PIS: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._PIS;
end;

procedure FUNCIONARIO.set_PIS(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._PIS := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function FUNCIONARIO.get__RG: string;
begin
  Result := (string(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember + 
      2))));
end;

procedure FUNCIONARIO.set__RG(Value: string);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 2), (System.Object(Value)));
end;

function FUNCIONARIO.get_RG: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._RG;
end;

procedure FUNCIONARIO.set_RG(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._RG := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function FUNCIONARIO.get__PAI: string;
begin
  Result := (string(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember + 
      1))));
end;

procedure FUNCIONARIO.set__PAI(Value: string);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 1), (System.Object(Value)));
end;

function FUNCIONARIO.get_PAI: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._PAI;
end;

procedure FUNCIONARIO.set_PAI(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._PAI := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function FUNCIONARIO.get__MAE: string;
begin
  Result := (string(Self._content.get_MemberByIndex((FUNCIONARIOFirstMember + 
      0))));
end;

procedure FUNCIONARIO.set__MAE(Value: string);
begin
  Self._content.set_MemberByIndex((FUNCIONARIOFirstMember + 0), (System.Object(Value)));
end;

function FUNCIONARIO.get_MAE: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._MAE;
end;

procedure FUNCIONARIO.set_MAE(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._MAE := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;



constructor FUNCIONARIO.FUNCIONARIOListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function FUNCIONARIO.FUNCIONARIOListAdapter.Add(value: FUNCIONARIO): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function FUNCIONARIO.FUNCIONARIOListAdapter.Contains(value: FUNCIONARIO): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function FUNCIONARIO.FUNCIONARIOListAdapter.IndexOf(value: FUNCIONARIO): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure FUNCIONARIO.FUNCIONARIOListAdapter.Insert(index: Integer; value: FUNCIONARIO);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure FUNCIONARIO.FUNCIONARIOListAdapter.Remove(value: FUNCIONARIO);
begin
  Self.Adaptee.Remove(value);
end;

function FUNCIONARIO.FUNCIONARIOListAdapter.get_Item(index: Integer): FUNCIONARIO;
begin
  Result := FUNCIONARIO(Adaptee[index]);
end;

procedure FUNCIONARIO.FUNCIONARIOListAdapter.set_Item(index: Integer; value: FUNCIONARIO);
begin
  Adaptee[index] := value;
end;

























end.
